using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.DAL
{
	public partial class STD_FORMDB : VIRP.DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public STD_FORMDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public STD_FORM GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_FORM_ID)
		{
			STD_FORM objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_STD_FORM_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, STD_FORM_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public STD_FORM GetItemByToolFormId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 TOOL_FORM_ID)
        {
            STD_FORM objReturn = null;

            try
            {
                using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_FORM_getitemByToolFormId(CURRENT_USER, CURRENT_REGISTRY_ID, TOOL_FORM_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public STD_FORM GetItemByBprFormId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string BPR_FORM_ID)
        {
            STD_FORM objReturn = null;

            try
            {
                using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_FORM_getitemByBprFormId(CURRENT_USER, CURRENT_REGISTRY_ID, BPR_FORM_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_FORM> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<STD_FORM> objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_STD_FORM_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_FORM objSave)
		{
			Int32? objReturn = objSave.STD_FORM_ID;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_STD_FORM_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.BPR_FORM_ID, DateTime.Now, objSave.CREATEDBY, objSave.FOLLOWUP_FLAG, objSave.NAME, objSave.OMB, ref objReturn, objSave.TITLE, objSave.TOOL_FORM_ID, DateTime.Now, objSave.UPDATEDBY, objSave.VERSION);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_FORM_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_STD_FORM_delete(CURRENT_USER, CURRENT_REGISTRY_ID, STD_FORM_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
